﻿using Microsoft.Identity.Client;
using Microsoft.Identity.Web;
using System.Net.Http.Headers;
using System.Text.Encodings.Web;
using System.Text.Json;

var config = new {
    // Full directory URL, in the form of https://login.microsoftonline.com/<tenant_id>
    Authority = " https://login.microsoftonline.com/e8ddb777-121f-4abc-a113-6b91d4b5defc",
    // Enter the client ID obtained from the Microsoft Entra admin center
    ClientId = "e8d0159f-3df0-4b5a-8e5a-3d0d35bdd330",
    // Client secret 'Value' (not its ID) from 'Client secrets' in the Microsoft Entra admin center
    ClientSecret = "Qc68Q~Za2uZ382...",
    // Client 'Object ID' of app registration in Microsoft Entra admin center - this value is a GUID
    ClientObjectId = "409c9b95-8fcf-4319-8593-86b0c3913bf1"
};

// This app instance should be a long-lived instance because
// it maintains the in-memory token cache.
IConfidentialClientApplication msalClient = ConfidentialClientApplicationBuilder.Create(config.ClientId)
                    .WithClientSecret(config.ClientSecret)
                    .WithAuthority(new Uri(config.Authority))
                    .Build();

msalClient.AddInMemoryTokenCache();

string[] scopes = {
"api://5f9d20ce-8ac7-4115-80a7-2f1b2acd7bda/.default"
};

const string ilapAnalyticsUrl = "https://app-ilapanalytics-api-beta.azurewebsites.net/";

AuthenticationResult msalAuthenticationResult = await msalClient.AcquireTokenForClient(scopes).ExecuteAsync();

var httpClient = new HttpClient();

//Send a request to Ilap Analytics to GET all ReportScheduleTypes

using var request = new HttpRequestMessage(HttpMethod.Get, $"{ilapAnalyticsUrl}/api/ReportScheduleType");
request.Headers.Authorization = new AuthenticationHeaderValue("Bearer", msalAuthenticationResult.AccessToken);
var graphResponseMessage = await httpClient.SendAsync(request);
graphResponseMessage.EnsureSuccessStatusCode();

//Write the response as JSON Formatted text to the Console
using var graphResponseJson = JsonDocument.Parse(await graphResponseMessage.Content.ReadAsStreamAsync());
Console.WriteLine(JsonSerializer.Serialize(graphResponseJson, new JsonSerializerOptions { WriteIndented = true, Encoder = JavaScriptEncoder.UnsafeRelaxedJsonEscaping }));
